/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block;

import com.technicalitiesmc.lib.block.BlockComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public abstract class BlockComponentData<C extends BlockComponent.WithData<?>>
implements ICapabilityProvider {
    private final Context context;

    protected BlockComponentData(Context context) {
        this.context = context;
    }

    public void onLoad() {
    }

    public void onChunkUnloaded() {
    }

    public void onRemoved() {
    }

    public void addModelData(ModelDataMap.Builder builder) {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
    }

    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    public void load(CompoundTag tag) {
    }

    public CompoundTag saveDescription(CompoundTag tag) {
        return tag;
    }

    public void loadDescription(CompoundTag tag) {
    }

    protected final Level getLevel() {
        return this.context.getLevel();
    }

    protected final BlockPos getBlockPos() {
        return this.context.getBlockPos();
    }

    protected final BlockState getBlockState() {
        return this.context.getBlockState();
    }

    protected final C getComponent() {
        return (C)this.context.getComponent();
    }

    protected final void markUnsaved() {
        this.context.markUnsaved();
    }

    protected final void updateComparators() {
        this.context.updateComparators();
    }

    protected final void markDataUpdated() {
        this.context.markDataUpdated();
    }

    public static interface Context {
        public Level getLevel();

        public BlockPos getBlockPos();

        public BlockState getBlockState();

        public BlockComponent.WithData<?> getComponent();

        public void markUnsaved();

        public void updateComparators();

        public void markDataUpdated();
    }

    @FunctionalInterface
    public static interface Constructor<T extends BlockComponentData> {
        public T create(Context var1);
    }
}

